/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWXMLSchemaValueDialog
extends VWModalDialog
implements IVWToolbarBorderActionListener,
ActionListener {
    private VWToolbarBorder m_schemaDefToolbar = null;
    private JRadioButton m_useServerFileRB = null;
    private JRadioButton m_specifySchemaRB = null;
    private JTextField m_serverFileTextField = null;
    private JButton m_loadFromServerButton = null;
    private JTextArea m_schemaDefTextArea = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private String m_schemaName = null;

    public VWXMLSchemaValueDialog(VWAuthPropertyData authPropertyData) {
        super(authPropertyData.getMainContainer());
        this.m_authPropertyData = authPropertyData;
        this.createControls();
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (!event.getSource().equals(this.m_schemaDefToolbar)) {
                return;
            }
            switch (event.getID()) {
                case 0x100000: {
                    try {
                        VWWebServiceUtils wsUtils;
                        String schema = this.m_serverFileTextField.getText();
                        if (schema == null || schema.trim().length() == 0) {
                            schema = this.m_schemaDefTextArea.getText();
                        }
                        if ((wsUtils = this.m_authPropertyData.getWebServiceUtils()) != null && (schema = wsUtils.isValidSchema(this.m_schemaName, schema)) != null) {
                            String formattedString = VWStringUtils.xmlPrettyFormat(schema);
                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_xmlIsWellFormed, 2);
                            if (formattedString != null && formattedString.length() > 0) {
                                if (this.m_useServerFileRB.isSelected()) {
                                    this.m_schemaDefTextArea.setText(formattedString);
                                    break;
                                }
                                this.m_schemaDefTextArea.setText(formattedString);
                            }
                        }
                        break;
                    }
                    catch (Exception ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = VWResource.s_xmlIsNotWellFormed;
                        }
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, VWResource.s_errorCheckingSchema, 1);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_useServerFileRB)) {
            this.performSchemaSourceAction(true);
        } else if (source.equals(this.m_specifySchemaRB)) {
            this.performSchemaSourceAction(false);
        } else if (source.equals(this.m_loadFromServerButton)) {
            this.performLoadFromServerAction();
        } else if (source.equals(this.m_okButton)) {
            this.m_nExitStatus = 0;
            this.setVisible(false);
        } else if (source.equals(this.m_cancelButton)) {
            this.m_nExitStatus = 1;
            this.setVisible(false);
        } else if (source.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh163.htm");
        }
    }

    protected void reinitialize(String schemaName, String schema, boolean bCanEditItem) {
        try {
            VWWebServiceUtils wsUtils;
            this.m_schemaName = schemaName;
            if (this.m_schemaName == null) {
                this.m_schemaName = VWResource.s_undefined;
            }
            if ((wsUtils = this.m_authPropertyData.getWebServiceUtils()) != null && (schema == null || schema.length() == 0 || wsUtils.isParsableSchema(schema))) {
                this.m_specifySchemaRB.removeActionListener(this);
                this.m_specifySchemaRB.setSelected(true);
                this.m_specifySchemaRB.addActionListener(this);
                this.m_serverFileTextField.setText(null);
                this.m_serverFileTextField.setEditable(false);
                this.m_loadFromServerButton.setEnabled(false);
                this.m_schemaDefTextArea.setText(schema);
                this.m_schemaDefTextArea.setEditable(bCanEditItem);
            } else {
                this.m_useServerFileRB.removeActionListener(this);
                this.m_useServerFileRB.setSelected(true);
                this.m_useServerFileRB.addActionListener(this);
                this.m_serverFileTextField.setText(schema);
                this.m_serverFileTextField.setEditable(bCanEditItem);
                this.m_loadFromServerButton.setEnabled(bCanEditItem);
                this.m_schemaDefTextArea.setText(null);
                this.m_schemaDefTextArea.setEditable(false);
            }
            int nAction = 1;
            if (!bCanEditItem) {
                nAction = 2;
            }
            this.m_schemaDefToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_schemaDefToolbar.getClientPanel(), nAction, Integer.MAX_VALUE));
            this.m_specifySchemaRB.setEnabled(bCanEditItem);
            this.m_useServerFileRB.setEnabled(bCanEditItem);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getSchema() {
        try {
            if (this.m_useServerFileRB.isSelected()) {
                return this.m_serverFileTextField.getText();
            }
            return this.m_schemaDefTextArea.getText();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void releaseReferences() {
        if (this.m_schemaDefToolbar != null) {
            this.m_schemaDefToolbar.removeToolbarBorderActionNotifier(this);
            this.m_schemaDefToolbar.releaseReferences();
            this.m_schemaDefToolbar = null;
        }
        if (this.m_useServerFileRB != null) {
            this.m_useServerFileRB.removeActionListener(this);
            this.m_useServerFileRB = null;
        }
        if (this.m_specifySchemaRB != null) {
            this.m_specifySchemaRB.removeActionListener(this);
            this.m_specifySchemaRB = null;
        }
        if (this.m_serverFileTextField != null) {
            this.m_serverFileTextField.removeAll();
            this.m_serverFileTextField = null;
        }
        if (this.m_loadFromServerButton != null) {
            this.m_loadFromServerButton.removeActionListener(this);
            this.m_loadFromServerButton = null;
        }
        if (this.m_schemaDefTextArea != null) {
            this.m_schemaDefTextArea.removeAll();
            this.m_schemaDefTextArea = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        this.m_authPropertyData = null;
        this.m_schemaName = null;
        super.removeReferences();
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setSize(new Dimension(640, 480));
            this.setTitle(VWResource.s_schemaDefinition);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        try {
            this.m_schemaDefToolbar = new VWToolbarBorder(VWResource.s_schemaDefinition, 0x100000);
            this.m_schemaDefToolbar.addToolbarBorderActionNotifier(this);
            JPanel childPanel = this.m_schemaDefToolbar.getClientPanel();
            childPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 0, 5);
            ButtonGroup authenticationGrp = new ButtonGroup();
            this.m_specifySchemaRB = new JRadioButton(VWResource.s_specifyValue);
            this.m_specifySchemaRB.setSelected(true);
            this.m_specifySchemaRB.addActionListener(this);
            authenticationGrp.add(this.m_specifySchemaRB);
            childPanel.add((Component)this.m_specifySchemaRB, gbCons);
            ++gbCons.gridx;
            this.m_useServerFileRB = new JRadioButton(VWResource.s_useServerFile);
            this.m_useServerFileRB.setSelected(false);
            this.m_useServerFileRB.addActionListener(this);
            authenticationGrp.add(this.m_useServerFileRB);
            childPanel.add((Component)this.m_useServerFileRB, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_serverFileTextField = new JTextField();
            this.m_serverFileTextField.setEditable(false);
            childPanel.add((Component)this.m_serverFileTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_loadFromServerButton = new JButton(VWResource.s_load);
            this.m_loadFromServerButton.setEnabled(false);
            this.m_loadFromServerButton.addActionListener(this);
            childPanel.add((Component)this.m_loadFromServerButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            this.m_schemaDefTextArea = new JTextArea();
            this.m_schemaDefTextArea.setTabSize(4);
            childPanel.add((Component)new JScrollPane(this.m_schemaDefTextArea), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_schemaDefToolbar;
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setDefaultCapable(true);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void performSchemaSourceAction(boolean bUseServerFile) {
        this.m_serverFileTextField.setEditable(bUseServerFile);
        this.m_loadFromServerButton.setEnabled(bUseServerFile);
        this.m_schemaDefTextArea.setEditable(!bUseServerFile);
        this.m_serverFileTextField.setText(null);
        this.m_schemaDefTextArea.setText(null);
    }

    private void performLoadFromServerAction() {
        try {
            VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
            if (wsUtils != null) {
                String fileName = this.m_serverFileTextField.getText();
                String schema = wsUtils.isValidSchema(this.m_schemaName, fileName);
                if (schema != null) {
                    schema = VWStringUtils.xmlPrettyFormat(schema);
                }
                this.m_schemaDefTextArea.setText(schema);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = VWResource.s_errorLoadingSchemaFromFile;
            }
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, VWResource.s_errorMessageTitle, 1);
            this.m_schemaDefTextArea.setText(null);
        }
    }
}

